//////////////////////////////////////////////
// BufferView.js
//
//////////////////////////////////////////////

/// Class ------------------------------------

nkMemoryTests.BufferView = class BufferView extends nkDebug.TestClass
{
	// Statics
	static instance = new BufferView ("nkMemoryTests.containers") ;

	// Utils
	getBufferConstructor (managed)
	{
		return managed ? nkMemory.Buffer : nkMemory.unmanaged.Buffer ;
	}

	getBufferViewConstructor (managed)
	{
		return managed ? nkMemory.BufferView : nkMemory.unmanaged.BufferView ;
	}

	// Tests
	testCreateFromBuffer (managed0, managed1)
	{
		const bufferCtor = BufferView.instance.getBufferConstructor(managed0) ;
		const viewCtor = BufferView.instance.getBufferViewConstructor(managed1) ;

		const buffer = new bufferCtor (new Uint8Array ([0, 1, 2, 3, 4])) ;
		const view = new viewCtor (buffer) ;

		if (managed0 && !managed1)
			nkDebug.TestUtils.check(view.getSize() == 0, "An unmanaged view cannot be created from a managed buffer (lifetime issues)") ;
		else
		{
			nkDebug.TestUtils.check(view.getSize() == 5, "Wrong view size") ;

			for (let i = 0 ; i < view.getSize() ; ++i)
			{
				nkDebug.TestUtils.check(buffer.getData()[i] == view.getData()[i], "Wrong view value") ;
				buffer.getData()[i] = 4 ;
				nkDebug.TestUtils.check(buffer.getData()[i] == view.getData()[i], "Wrong view value after buffer change") ;
				view.getData()[i] = 5 ;
				nkDebug.TestUtils.check(buffer.getData()[i] == view.getData()[i], "Wrong buffer value after view change") ;
			}
		}

		if (!managed0)
			buffer.delete() ;

		if (!managed1)
			view.delete() ;
	}

	testCreateFromView (managedSource, managed0, managed1)
	{
		const bufferCtor = BufferView.instance.getBufferConstructor(managedSource) ;
		const view0Ctor = BufferView.instance.getBufferViewConstructor(managed0) ;
		const view1Ctor = BufferView.instance.getBufferViewConstructor(managed1) ;

		const buffer = new bufferCtor (new Uint8Array ([0, 1, 2, 3, 4])) ;
		const view0 = new view0Ctor (buffer) ;
		const view1 = new view1Ctor (view0) ;

		if (managedSource && !managed1)
			nkDebug.TestUtils.check(view1.getSize() == 0, "An unmanaged view cannot be created from a managed buffer (lifetime issues)") ;
		else
		{
			nkDebug.TestUtils.check(view1.getSize() == 5, "Wrong view size") ;

			for (let i = 0 ; i < view1.getSize() ; ++i)
			{
				nkDebug.TestUtils.check(buffer.getData()[i] == view1.getData()[i], "Wrong view value") ;
				buffer.getData()[i] = 4 ;
				nkDebug.TestUtils.check(buffer.getData()[i] == view1.getData()[i], "Wrong view value after buffer change") ;
				view1.getData()[i] = 5 ;
				nkDebug.TestUtils.check(buffer.getData()[i] == view1.getData()[i], "Wrong buffer value after view change") ;
			}
		}

		if (!managedSource)
			buffer.delete() ;

		if (!managed0)
			view0.delete() ;

		if (!managed1)
			view1.delete() ;
	}

	nkTests =
	{
		// Constructors
		FromBufferConstructorUnmanaged : function () {BufferView.instance.testCreateFromBuffer(false, false) ;},
		FromBufferConstructorUnmanagedManaged : function () {BufferView.instance.testCreateFromBuffer(false, true) ;},
		FromBufferConstructorManagedUnmanaged : function () {BufferView.instance.testCreateFromBuffer(true, false) ;},
		FromBufferConstructorManaged : function () {BufferView.instance.testCreateFromBuffer(true, true) ;},

		FromViewConstructorUnmanaged : function () {BufferView.instance.testCreateFromView(false, false, false) ;},
		FromViewConstructorUnmanagedUnmanagedManaged : function () {BufferView.instance.testCreateFromView(false, false, true) ;},
		FromViewConstructorUnmanagedManagedManaged : function () {BufferView.instance.testCreateFromView(false, true, true) ;},
		FromViewConstructorUnmanagedManagedUnmanaged : function () {BufferView.instance.testCreateFromView(false, true, false) ;},
		FromViewConstructorMmanagedManagedUnmanaged : function () {BufferView.instance.testCreateFromView(true, true, false) ;},
		FromViewConstructorManaged : function () {BufferView.instance.testCreateFromView(true, true, true) ;},
	}
}